capture log close

global XVAR log_hy log_hnetw i.dm_age_years i.dm_gender i.em_mainjob_type i.parttime ///
	i.dm_education i.dm_citizen i.dm_ghealth i.dm_marstatus2 i.dm_hsize2 i.tempo i.country
	
*********************************************************
* REFORM EFFECT						*
*********************************************************

* ADD REFORM TO DATASET
insheet using "$input_ext/reforms_months.csv", clear delimiter("$DELIMITER")
tostring reform_*, replace
reshape long reform_a_ reform_b_, i(country country_l) j(year)
expand 12
bysort country year: g month=_n

g reform_age_incr=1 if month==1 & strpos(reform_a_, "January")!=0
replace reform_age_incr=1 if month==2 & strpos(reform_a_, "February")!=0
replace reform_age_incr=1 if month==3 & strpos(reform_a_, "March")!=0
replace reform_age_incr=1 if month==4 & strpos(reform_a_, "April")!=0
replace reform_age_incr=1 if month==5 & strpos(reform_a_, "May")!=0
replace reform_age_incr=1 if month==6 & strpos(reform_a_, "June")!=0
replace reform_age_incr=1 if month==7 & strpos(reform_a_, "July")!=0
replace reform_age_incr=1 if month==8 & strpos(reform_a_, "August")!=0
replace reform_age_incr=1 if month==9 & strpos(reform_a_, "September")!=0
replace reform_age_incr=1 if month==10 & strpos(reform_a_, "October")!=0
replace reform_age_incr=1 if month==11 & strpos(reform_a_, "November")!=0
replace reform_age_incr=1 if month==12 & strpos(reform_a_, "December")!=0
recode reform_age_incr .=0

g reform_red_pen=1 if month==1 & strpos(reform_b_, "January")!=0
replace reform_red_pen=1 if month==2 & strpos(reform_b_, "February")!=0
replace reform_red_pen=1 if month==3 & strpos(reform_b_, "March")!=0
replace reform_red_pen=1 if month==4 & strpos(reform_b_, "April")!=0
replace reform_red_pen=1 if month==5 & strpos(reform_b_, "May")!=0
replace reform_red_pen=1 if month==6 & strpos(reform_b_, "June")!=0
replace reform_red_pen=1 if month==7 & strpos(reform_b_, "July")!=0
replace reform_red_pen=1 if month==8 & strpos(reform_b_, "August")!=0
replace reform_red_pen=1 if month==9 & strpos(reform_b_, "September")!=0
replace reform_red_pen=1 if month==10 & strpos(reform_b_, "October")!=0
replace reform_red_pen=1 if month==11 & strpos(reform_b_, "November")!=0
replace reform_red_pen=1 if month==12 & strpos(reform_b_, "December")!=0
recode reform_red_pen .=0

g tempo=ym(year,month)

* reforms in previous 5 years
g sum_reform_age_incr = .
g sum_reform_red_pen = .

xtset country tempo

forval n = 516(1)671 {
         cap drop i`n'
         g i`n' = 1 if  `n'>tempo & (`n'-tempo) <= 60
         bysort country: egen sum_reform_age_incr`n' = total(reform_age_incr) if i`n'==1
         replace sum_reform_age_incr = l.sum_reform_age_incr`n' if tempo==`n'
         bysort country: egen sum_reform_red_pen`n' = total(reform_red_pen) if i`n'==1
         replace sum_reform_red_pen = l.sum_reform_red_pen`n' if tempo==`n'
         drop  i`n'
         drop sum_reform_age_incr`n'
         drop sum_reform_red_pen`n'
         }

xtset country tempo

g from_reform_age_incr=reform_age_incr==1
replace from_reform_age_incr=l.from_reform_age_incr+1 if reform_age_incr==0 & l.from_reform_age_incr!=0 & tempo>=457

g from_reform_red_pen=reform_red_pen==1
replace from_reform_red_pen=l.from_reform_red_pen+1 if reform_red_pen==0 & l.from_reform_red_pen!=0 & tempo>=457

sum tempo
g tempo2=-tempo+456+671

xtset country tempo2

g to_reform_age_incr=reform_age_incr==1
replace to_reform_age_incr=l.to_reform_age_incr+1 if reform_age_incr==0 & l.to_reform_age_incr!=0 & tempo2>=457

g to_reform_red_pen=reform_red_pen==1
replace to_reform_red_pen=l.to_reform_red_pen+1 if reform_red_pen==0 & l.to_reform_red_pen!=0 & tempo2>=457

xtset country tempo

* I build the inverse
g inv_to_reform_age_incr=to_reform_age_incr
g inv_from_reform_age_incr=from_reform_age_incr
g inv_to_reform_red_pen=to_reform_red_pen
g inv_from_reform_red_pen=from_reform_red_pen

replace inv_to_reform_age_incr=0 if inv_to_reform_age_incr>25
replace inv_from_reform_age_incr=0 if inv_from_reform_age_incr>25

replace inv_to_reform_red_pen=0 if inv_to_reform_red_pen>25
replace inv_from_reform_red_pen=0 if inv_from_reform_red_pen>25

replace inv_to_reform_age_incr=-inv_to_reform_age_incr+26 if inv_to_reform_age_incr!=0
replace inv_from_reform_age_incr=-inv_from_reform_age_incr+26 if inv_from_reform_age_incr!=0

replace inv_to_reform_red_pen=-inv_to_reform_red_pen+26 if inv_to_reform_red_pen!=0
replace inv_from_reform_red_pen=-inv_from_reform_red_pen+26 if inv_from_reform_red_pen!=0

egen D_to_reform_age_incr=rowmax(inv_to_reform_age_incr inv_from_reform_age_incr)
egen D_to_reform_red_pen=rowmax(inv_to_reform_red_pen inv_from_reform_red_pen)

g ptr_to_age_incr=D_to_reform_age_incr if D_to_reform_age_incr==inv_to_reform_age_incr
replace ptr_to_age_incr=0 if D_to_reform_age_incr==25
g ptr_from_age_incr=D_to_reform_age_incr if D_to_reform_age_incr==inv_from_reform_age_incr
recode ptr_to_age_incr ptr_from_age_incr (.=0)
replace ptr_from_age_incr=ptr_from_age_incr/25
replace ptr_to_age_incr=ptr_to_age_incr/25

g ptr_to_red_pen=D_to_reform_red_pen if D_to_reform_red_pen==inv_to_reform_red_pen
replace ptr_to_red_pen=0 if D_to_reform_red_pen==25
g ptr_from_red_pen=D_to_reform_red_pen if D_to_reform_red_pen==inv_from_reform_red_pen
recode ptr_to_red_pen ptr_from_red_pen (.=0)
replace ptr_from_red_pen=ptr_from_red_pen/25
replace ptr_to_red_pen=ptr_to_red_pen/25	

g timeS_reform_age_incr=0 if inv_to_reform_age_incr==0 & inv_from_reform_age_incr==0
replace timeS_reform_age_incr=1 if inv_to_reform_age_incr>12 & inv_to_reform_age_incr<25 & D_to_reform_age_incr==inv_to_reform_age_incr
replace timeS_reform_age_incr=2 if inv_to_reform_age_incr==25 & D_to_reform_age_incr==inv_to_reform_age_incr
replace timeS_reform_age_incr=2 if inv_from_reform_age_incr<25 & inv_from_reform_age_incr>12 & D_to_reform_age_incr==inv_from_reform_age_incr
recode timeS_reform_age_incr .=0

g timeS_reform_red_pen=0 if inv_to_reform_red_pen==0 & inv_from_reform_red_pen==0
replace timeS_reform_red_pen=1 if inv_to_reform_red_pen>12 & inv_to_reform_red_pen<25 & D_to_reform_red_pen==inv_to_reform_red_pen
replace timeS_reform_red_pen=2 if inv_to_reform_red_pen==25 & D_to_reform_red_pen==inv_to_reform_red_pen
replace timeS_reform_red_pen=2 if inv_from_reform_red_pen<25 & inv_from_reform_red_pen>12 & D_to_reform_red_pen==inv_from_reform_red_pen
recode timeS_reform_red_pen .=0

g ann_age_incr=0
g ann_red_pen=0

	*Austria - 11
	replace ann_age_incr=1 if country==11 & tempo>=ym(2003,3) & tempo<ym(2003,6)
	replace ann_age_incr=1 if country==11 & tempo>=ym(2004,10) & tempo<ym(2004,12)
	replace ann_age_incr=1 if country==11 & tempo>=ym(2010,10) & tempo<ym(2010,12)
	*Belgium - 23
	replace ann_age_incr=1 if country==23 & tempo>=ym(2005,10) & tempo<ym(2005,12)
	*Denmark - 18
	replace ann_age_incr=1 if country==18 & tempo>=ym(2006,4) & tempo<ym(2006,6)
	replace ann_age_incr=1 if country==18 & tempo>=ym(2011,5) & tempo<ym(2011,12)
	*France - 17
	replace ann_age_incr=1 if country==17 & tempo>=ym(2003,1) & tempo<ym(2003,7)
	replace ann_age_incr=1 if country==17 & tempo>=ym(2010,6) & tempo<ym(2010,11)
	replace ann_age_incr=1 if country==17 & tempo>=ym(2011,11) & tempo<ym(2011,12)
	replace ann_age_incr=1 if country==17 & tempo>=ym(2013,9) & tempo<ym(2014,1)
	*Germany - 12
	replace ann_age_incr=1 if country==12 & tempo>=ym(2006,11) & tempo<ym(2007,3)
	*Italy - 16
	replace ann_age_incr=1 if country==16 & tempo>=ym(2004,1) & tempo<ym(2004,7)
	replace ann_age_incr=1 if country==16 & tempo>=ym(2008,11) & tempo<ym(2009,7)
	replace ann_age_incr=1 if country==16 & tempo>=ym(2010,6) & tempo<ym(2010,7)
	*Netherlands - 14
	replace ann_age_incr=1 if country==14 & tempo>=ym(2012,5) & tempo<ym(2012,7)
	*Spain - 15
	replace ann_age_incr=1 if country==15 & tempo>=ym(2006,7) & tempo<ym(2007,12)
	replace ann_age_incr=1 if country==15 & tempo>=ym(2011,1) & tempo<ym(2011,8)
	replace ann_age_incr=1 if country==15 & tempo>=ym(2013,10) & tempo<ym(2013,12)
	*Switzerland - 20
	replace ann_age_incr=1 if country==20 & tempo>=ym(2000,2) & tempo<ym(2003,10)

	*Austria - 11
	replace ann_red_pen=1 if country==11 & tempo>=ym(2003,3) & tempo<ym(2003,6)
	replace ann_red_pen=1 if country==11 & tempo>=ym(2004,10) & tempo<ym(2004,12)
	replace ann_red_pen=1 if country==11 & tempo>=ym(2010,10) & tempo<ym(2010,12)
	*Denmark - 18
	replace ann_red_pen=1 if country==18 & tempo>=ym(2011,5) & tempo<ym(2011,12)
	*France - 17
	replace ann_red_pen=1 if country==17 & tempo>=ym(2003,1) & tempo<ym(2003,7)
	replace ann_red_pen=1 if country==17 & tempo>=ym(2013,9) & tempo<ym(2014,1)
	*Germany - 12
	replace ann_red_pen=1 if country==12 & tempo>=ym(2003,8) & tempo<ym(2004,6)
	*Italy - 16
	replace ann_red_pen=1 if country==16 & tempo>=ym(2004,1) & tempo<ym(2004,7)
	*Spain - 15
	replace ann_red_pen=1 if country==15 & tempo>=ym(2006,7) & tempo<ym(2007,12)
	replace ann_red_pen=1 if country==15 & tempo>=ym(2011,1) & tempo<ym(2011,8)
	replace ann_red_pen=1 if country==15 & tempo>=ym(2013,10) & tempo<ym(2013,12)
	*Switzerland - 20 (for the 2003,10 reform, composed by two different laws, there were two announcements, one in march 2000, the other in feb 2000)
	replace ann_red_pen=1 if country==20 & tempo>=ym(2000,2) & tempo<ym(2003,10)
	replace ann_red_pen=1 if country==20 & tempo>=ym(2006,1) & tempo<ym(2008,12)

ren year int_year
ren month int_month
sort country int_year int_month

merge 1:1 country int_year int_month using google_search
keep if _merge==3

drop _merge

save ES_GT, replace

* AGE INCREASE
use ES_GT, clear
keep if timeS_reform_age_incr!=0
table tempo country, c(mean D_to_reform_age_incr)
* I drop reforms not observed in the main analysis
* 11 12 14 15 include all
* Italy drop reforms in 2008-2010
drop if country==16 & tempo>=582 & tempo<=612
* France drop the beginning
drop if country==17 & tempo>=528 & tempo<=534
* 18 20 23 tutte

tab ptr_to_age_incr timeS_reform_age_incr

g t=0 if D_to_reform_age_incr==25
replace t=D_to_reform_age_incr-25 if timeS_reform_age_incr==1
replace t=-D_to_reform_age_incr+25 if timeS_reform_age_incr==2
tab t, g(Dt)
replace google=google/100
reg google Dt1-Dt12 Dt14-Dt25

tab t if ann_age_incr==0 
tab t if ann_age_incr==1

forvalues i=1(1)12 {
	g AXDt`i'=Dt`i'*ann_age_incr
	g NXDt`i'=Dt`i'*(1-ann_age_incr)
	}

reg google AXDt* NXDt* Dt14-Dt25 i.country, robust
est store evGTage
*test AXDt1 AXDt2 AXDt3 AXDt4 AXDt5 AXDt6 AXDt7 AXDt8 AXDt9 AXDt10 AXDt11 AXDt12 
*test NXDt1 NXDt2 NXDt3 NXDt4 NXDt5 NXDt6 NXDt7 NXDt8 NXDt9 NXDt10 NXDt11 NXDt12 

test AXDt1 AXDt2 AXDt3 AXDt4 AXDt5 AXDt6 AXDt7 AXDt8 AXDt9 AXDt10 AXDt11 AXDt12  NXDt1 NXDt2 NXDt3 NXDt4 NXDt5 NXDt6 NXDt7 NXDt8 NXDt9 NXDt10 NXDt11 NXDt12 
test Dt14 Dt15 Dt16 Dt17 Dt18 Dt19 Dt20 Dt21 Dt22 Dt23 Dt25 

preserve
	clear
	set obs 25
	g t=_n-13
	tab t, g(Dt)
	expand 2, gen(ann_age_incr)
	g country=11
	forvalues i=1(1)12 {
	g AXDt`i'=Dt`i'*ann_age_incr
	g NXDt`i'=Dt`i'*(1-ann_age_incr)
	}
	est restore evGTage
	predict xb, xb
	sum xb if t==0
	replace xb=xb-r(mean)
	
	graph twoway (line xb t if ann_age_incr==0, lcolor(red) lwidth(thick)) (line xb t if ann_age_incr==1 & t>=-7 & t<=0, lcolor(blue) lpattern(dash) lwidth(thick)), ///
		legend(order(1 "G(0) - reform not yet announced" 2 "G(0) - reform already announced") rows(2) size(medium)) ytitle("") ///
		xtitle("months to/from reform", size(medium)) yscale(range(-.3 .2)) ylabel(-.3(.1).2, labsize(medium)) xlabel(,labsize(medium))
	graph export "$output/figure_A4a.eps", as(eps) replace
restore

/* FIGURE A.4a */

* RED PEN
use ES_GT, clear
keep if timeS_reform_red_pen!=0
table tempo country, c(mean D_to_reform_red_pen)
* I drop reforms not observed in the main analysis
* Austria the early 2003 reform
drop if country==11 & tempo>=528 & tempo<=529
* 12 14 15 16 ok
* France drop the early reform
drop if country==17 & tempo<=534
* 18 ok
drop if country==20 & tempo>=575 & tempo<=599
* 23 ok

tab ptr_to_age_incr timeS_reform_red_pen

g t=0 if D_to_reform_red_pen==25
replace t=D_to_reform_red_pen-25 if timeS_reform_red_pen==1
replace t=-D_to_reform_red_pen+25 if timeS_reform_red_pen==2
tab t, g(Dt)
replace google=google/100
reg google Dt1-Dt12 Dt14-Dt25

tab t if ann_red_pen==0 
tab t if ann_red_pen==1

forvalues i=1(1)12 {
	g AXDt`i'=Dt`i'*ann_red_pen
	g NXDt`i'=Dt`i'*(1-ann_red_pen)
	}

reg google AXDt* NXDt* Dt14-Dt25 i.country, robust
est store evGTpen
*test AXDt1 AXDt2 AXDt3 AXDt4 AXDt5 AXDt6 AXDt7 AXDt8 AXDt9 AXDt10 AXDt11 AXDt12 
*test NXDt1 NXDt2 NXDt3 NXDt4 NXDt5 NXDt6 NXDt7 NXDt8 NXDt9 NXDt10 NXDt11 NXDt12 

test AXDt1 AXDt2 AXDt3 AXDt4 AXDt5 AXDt6 AXDt7 AXDt8 AXDt9 AXDt10 AXDt11 AXDt12  NXDt1 NXDt2 NXDt3 NXDt4 NXDt5 NXDt6 NXDt7 NXDt8 NXDt9 NXDt10 NXDt11 NXDt12 
test Dt14 Dt15 Dt16 Dt17 Dt18 Dt19 Dt20 Dt21 Dt22 Dt23 Dt25 

preserve
	clear
	set obs 25
	g t=_n-13
	tab t, g(Dt)
	expand 2, gen(ann_red_pen)
	g country=11
	forvalues i=1(1)12 {
	g AXDt`i'=Dt`i'*ann_red_pen
	g NXDt`i'=Dt`i'*(1-ann_red_pen)
	}
	est restore evGTpen
	predict xb, xb
	sum xb if t==0
	replace xb=xb-r(mean)

/* FIGURE A.4b */
	graph twoway (line xb t if ann_red_pen==0, lcolor(red) lwidth(thick)) (line xb t if ann_red_pen==1 & t>=-7 & t<=0, lcolor(blue) lpattern(dash) lwidth(thick)), ///
		legend(order(1 "G(0) - reform not yet announced" 2 "G(0) - reform already announced") rows(2) size(medium)) ytitle("") ///
		xtitle("months to/from reform", size(medium)) yscale(range(-.3 .2)) ylabel(-.3(.1).2, labsize(medium)) xlabel(,labsize(medium))
	graph export "$output/figure_A4b.eps", as(eps) replace
restore
